/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorGoal
implements AStarGoal<VectorNode> {
    private final Vector goal;
    private final float leeway;

    public VectorGoal(Location dest, float range) {
        this.leeway = range;
        this.goal = dest.toVector().setX(dest.getBlockX()).setY(dest.getBlockY()).setZ(dest.getBlockZ());
    }

    @Override
    public float g(VectorNode from, VectorNode to) {
        return from.distance(to);
    }

    public Vector getGoalVector() {
        return this.goal.clone();
    }

    @Override
    public float getInitialCost(VectorNode node) {
        return node.distance(this.goal);
    }

    @Override
    public float h(VectorNode from) {
        return from.heuristicDistance(this.goal);
    }

    @Override
    public boolean isFinished(VectorNode node) {
        return this.goal.equals((Object)node.location) || (double)node.distance(this.goal) <= (double)this.leeway;
    }
}

