/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitTemplateParser;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class TraitLoaderAction
implements Consumer<NPC> {
    private final List<Function<NPC, Trait>> actions = new ArrayList<Function<NPC, Trait>>();

    public TraitLoaderAction(TemplateRegistry.TemplateErrorReporter errors, TemplateWorkspace workspace, DataKey traits) {
        for (DataKey key : traits.getIntegerSubKeys()) {
            if (key.hasSubKeys()) {
                if (!key.keyExists("name")) {
                    errors.addError(key.getPath() + ": Missing trait name");
                    continue;
                }
                String traitName = key.getString("name");
                TraitTemplateParser parser = CitizensAPI.getTraitFactory().getTemplateParser(traitName);
                if (parser == null) {
                    errors.addError(key.getPath() + ": Unknown trait " + traitName);
                    continue;
                }
                TraitTemplateParser.TemplateParser tp = parser.getTemplateParser();
                if (tp == null) continue;
                this.actions.add(npc -> (Trait)tp.apply(new TraitTemplateParser.TraitParserContext((NPC)npc, workspace), key));
                continue;
            }
            String shortTraitDescriptor = key.getString("").trim();
            String[] parts = shortTraitDescriptor.split(" ");
            String traitNamePartial = parts[0];
            TraitTemplateParser parser = CitizensAPI.getTraitFactory().getTemplateParser(traitNamePartial);
            if (parser == null) {
                errors.addError(key.getPath() + ": Unknown trait " + traitNamePartial);
                continue;
            }
            TraitTemplateParser.ShortTemplateParser stp = parser.getShortTemplateParser();
            if (stp == null) continue;
            CommandContext ctx = new CommandContext((CommandSender)Bukkit.getConsoleSender(), parts);
            this.actions.add(npc -> (Trait)stp.apply(new TraitTemplateParser.TraitParserContext((NPC)npc, workspace), ctx));
        }
    }

    @Override
    public void accept(NPC npc) {
        for (Function<NPC, Trait> action : this.actions) {
            Trait trait = action.apply(npc);
            if (trait == null) continue;
            npc.addTrait(trait);
        }
    }
}

