/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Supplier;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import org.bukkit.util.Vector;

public class PackedAStarStorage
implements AStarStorage {
    private final Long2FloatOpenHashMap closed = new Long2FloatOpenHashMap();
    private final Long2FloatOpenHashMap open = new Long2FloatOpenHashMap();
    private final Queue<AStarNode> queue = new PriorityQueue<AStarNode>(128);
    public static final Supplier<AStarStorage> FACTORY = PackedAStarStorage::new;

    private PackedAStarStorage() {
        this.closed.defaultReturnValue(Float.POSITIVE_INFINITY);
        this.open.defaultReturnValue(Float.POSITIVE_INFINITY);
    }

    @Override
    public void close(AStarNode node) {
        long key = this.packPosition((VectorNode)node);
        this.open.remove(key);
        this.closed.put(key, node.g);
    }

    @Override
    public AStarNode getBestNode() {
        return this.queue.peek();
    }

    @Override
    public void open(AStarNode node) {
        long key = this.packPosition((VectorNode)node);
        this.queue.offer(node);
        this.open.put(key, node.g);
        this.closed.remove(key);
    }

    private long packPosition(VectorNode node) {
        Vector vector = node.getVector();
        return ((long)vector.getBlockX() & 0x3FFFFFFL) << 38 | ((long)vector.getBlockZ() & 0x3FFFFFFL) << 12 | (long)vector.getBlockY() & 0xFFFL;
    }

    @Override
    public AStarNode removeBestNode() {
        return this.queue.poll();
    }

    @Override
    public boolean shouldExamine(AStarNode node) {
        float closedG;
        long key = this.packPosition((VectorNode)node);
        float openG = this.open.get(key);
        if (!Float.isInfinite(openG) && openG > node.g) {
            this.open.remove(key);
            openG = Float.POSITIVE_INFINITY;
        }
        if (!Float.isInfinite(closedG = this.closed.get(key)) && closedG > node.g) {
            this.closed.remove(key);
            closedG = Float.POSITIVE_INFINITY;
        }
        return Float.isInfinite(closedG) && Float.isInfinite(openG);
    }

    public String toString() {
        return "PackedAStarStorage [closed=" + this.closed + ", open=" + this.open + "]";
    }
}

