/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatTrigger
implements WaypointTrigger {
    @Persist(required=true)
    private List<String> lines;
    @Persist
    private double radius = -1.0;

    public ChatTrigger() {
    }

    public ChatTrigger(double radius, Collection<String> chatLines) {
        this.radius = radius;
        this.lines = Lists.newArrayList(chatLines);
    }

    @Override
    public String description() {
        return String.format("[[Chat]] [radius %f, %s]", this.radius, Joiner.on((String)", ").join(this.lines));
    }

    @Override
    public void onWaypointReached(NPC npc, Location waypoint) {
        if (!npc.isSpawned()) {
            return;
        }
        if (this.radius <= 0.0) {
            for (Player player : npc.getEntity().getWorld().getPlayers()) {
                for (String line : this.lines) {
                    Messaging.send((CommandSender)player, line);
                }
            }
        } else {
            for (Player player : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(npc.getEntity(), this.radius)) {
                for (String line : this.lines) {
                    Messaging.send((CommandSender)player, line);
                }
            }
        }
    }
}

