/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;

@TraitName(value="tropicalfishtrait")
public class TropicalFishTrait
extends Trait {
    @Persist
    private DyeColor bodyColor = DyeColor.BLUE;
    @Persist
    private TropicalFish.Pattern pattern = TropicalFish.Pattern.BRINELY;
    @Persist
    private DyeColor patternColor = DyeColor.BLUE;

    public TropicalFishTrait() {
        super("tropicalfishtrait");
    }

    public DyeColor getBodyColor() {
        return this.bodyColor;
    }

    public TropicalFish.Pattern getPattern() {
        return this.pattern;
    }

    public DyeColor getPatternColor() {
        return this.patternColor;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getCosmeticEntity() instanceof TropicalFish) {
            TropicalFish fish = (TropicalFish)this.npc.getCosmeticEntity();
            fish.setBodyColor(this.bodyColor);
            fish.setPatternColor(this.patternColor);
            fish.setPattern(this.pattern);
        }
    }

    public void setBodyColor(DyeColor color) {
        this.bodyColor = color;
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPatternColor(DyeColor color) {
        this.patternColor = color;
    }

    @Command(aliases={"npc"}, usage="tropicalfish (--body color) (--pattern pattern) (--patterncolor color)", desc="", modifiers={"tropicalfish"}, min=1, max=1, permission="citizens.npc.tropicalfish")
    @Requirements(selected=true, ownership=true, cosmeticTypes={EntityType.TROPICAL_FISH})
    public static void tropicalfish(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"body"}) DyeColor body, @Flag(value={"patterncolor"}) DyeColor patterncolor, @Flag(value={"pattern"}) TropicalFish.Pattern pattern) throws CommandException {
        TropicalFishTrait trait = npc.getOrAddTrait(TropicalFishTrait.class);
        String output = "";
        if (args.hasValueFlag("body")) {
            if (body == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            trait.setBodyColor(body);
            output = output + Messaging.tr("citizens.commands.npc.tropicalfish.body-color-set", Util.prettyEnum(body));
        }
        if (args.hasValueFlag("patterncolor")) {
            if (patterncolor == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            trait.setPatternColor(patterncolor);
            output = output + Messaging.tr("citizens.commands.npc.tropicalfish.pattern-color-set", Util.prettyEnum(patterncolor));
        }
        if (args.hasValueFlag("pattern")) {
            if (pattern == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-pattern", Util.listValuesPretty(TropicalFish.Pattern.values()));
            }
            trait.setPattern(pattern);
            output = output + Messaging.tr("citizens.commands.npc.tropicalfish.pattern-set", Util.prettyEnum(pattern));
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output);
    }
}

