/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Ocelot;

@TraitName(value="ocelotmodifiers")
public class OcelotModifiers
extends Trait {
    @Persist(value="sitting")
    private boolean sitting;
    @Persist(value="type")
    private Ocelot.Type type = Ocelot.Type.WILD_OCELOT;
    private static boolean SUPPORTS_CAT_TYPE = true;

    public OcelotModifiers() {
        super("ocelotmodifiers");
    }

    private void migrateToCat() {
        this.npc.getOrAddTrait(CatTrait.class).setSitting(this.sitting);
        this.npc.getOrAddTrait(CatTrait.class).setType(this.type);
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    public void setSitting(boolean sit) {
        this.sitting = sit;
        this.updateModifiers();
    }

    public void setType(Ocelot.Type type) {
        this.type = type;
        this.updateModifiers();
    }

    public boolean supportsOcelotType() {
        return SUPPORTS_CAT_TYPE;
    }

    private void updateModifiers() {
        if (!(this.npc.getCosmeticEntity() instanceof Ocelot)) {
            return;
        }
        Ocelot ocelot = (Ocelot)this.npc.getCosmeticEntity();
        NMS.setSitting(ocelot, this.sitting);
        if (!SUPPORTS_CAT_TYPE) {
            this.migrateToCat();
            return;
        }
        try {
            ocelot.setCatType(this.type);
        }
        catch (UnsupportedOperationException ex) {
            this.migrateToCat();
            SUPPORTS_CAT_TYPE = false;
        }
    }
}

