/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;

public class HPAGraphAStarNode
implements Comparable<HPAGraphAStarNode> {
    private final HPAGraphEdge edge;
    float g;
    float h;
    final HPAGraphNode node;
    HPAGraphAStarNode parent;

    public HPAGraphAStarNode(HPAGraphNode node, HPAGraphEdge edge) {
        this.node = node;
        this.edge = edge;
    }

    @Override
    public int compareTo(HPAGraphAStarNode o) {
        return Float.compare(this.g + this.h, o.g + o.h);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HPAGraphAStarNode other = (HPAGraphAStarNode)obj;
        return this.node.x == other.node.x && this.node.y == other.node.y && this.node.z == other.node.z;
    }

    public int hashCode() {
        return 31 * (31 * (31 + this.node.x) + this.node.y) + this.node.z;
    }

    HPAGraphEdge getEdge() {
        return this.edge;
    }

    public List<HPAGraphAStarNode> reconstructSolution() {
        ArrayList<HPAGraphAStarNode> parents = new ArrayList<HPAGraphAStarNode>();
        HPAGraphAStarNode current = this;
        while (current != null) {
            parents.add(current);
            current = current.parent;
        }
        Collections.reverse(parents);
        return parents;
    }

    public String toString() {
        return (this.edge != null ? this.edge.from.toString() : "") + "->" + this.node.toString();
    }
}

