/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class JumpingExaminer
implements BlockExaminer.AdditionalNeighbourGenerator {
    private final Supplier<Integer> entityHeight;
    private final Supplier<Float> speed;
    private static final int[] DX = new int[]{1, -1, 0, 0, 1, 1, -1, -1};
    private static final int[] DZ = new int[]{0, 0, 1, -1, 1, -1, 1, -1};
    private static final double GRAVITY = 0.08;
    private static final double[] INV_LEN = new double[]{1.0, 1.0, 1.0, 1.0, 0.7071067811865476, 0.7071067811865476, 0.7071067811865476, 0.7071067811865476};
    private static final double JUMP_VELOCITY = 0.42;
    private static final double XZ_DRAG = 0.91;

    public JumpingExaminer(Supplier<Integer> height, Supplier<Float> speed) {
        this.entityHeight = height;
        this.speed = speed;
    }

    @Override
    public void addNeighbours(BlockSource source, PathPoint point, List<PathPoint> neighbours) {
        Vector base = point.getVector();
        int minY = base.getBlockY() - 3;
        block0: for (int i = 0; i < 8; ++i) {
            double vx = (double)DX[i] * INV_LEN[i] * (double)this.speed.get().floatValue();
            double vy = 0.42;
            double vz = (double)DZ[i] * INV_LEN[i] * (double)this.speed.get().floatValue();
            double x = (double)base.getBlockX() + 0.5 + (double)DX[i] * INV_LEN[i] * 0.3;
            double y = base.getBlockY();
            double z = (double)base.getBlockZ() + 0.5 + (double)DZ[i] * INV_LEN[i] * 0.3;
            int px = base.getBlockX();
            int py = base.getBlockY();
            int pz = base.getBlockZ();
            block1: for (int tick = 0; tick < 60; ++tick) {
                x += vx;
                y += vy;
                z += vz;
                vx *= 0.91;
                vy = (vy - 0.08) * 0.98;
                vz *= 0.91;
                int bx = JumpingExaminer.floor(x);
                int by = JumpingExaminer.floor(y);
                int bz = JumpingExaminer.floor(z);
                if (bx == px && by == py && bz == pz) continue;
                if (by < minY || !source.isYWithinBounds(by) || !this.isClearColumn(source, bx, by, bz)) continue block0;
                int cx = px;
                int cy = py;
                int cz = pz;
                while (cx != bx || cy != by || cz != bz) {
                    if (cx != bx) {
                        cx += Integer.compare(bx, cx);
                    }
                    if (cy != by) {
                        cy += Integer.compare(by, cy);
                    }
                    if (cz != bz) {
                        cz += Integer.compare(bz, cz);
                    }
                    if (cy < minY || !source.isYWithinBounds(cy) || !this.isClearColumn(source, cx, cy, cz)) continue block1;
                    if (!source.isYWithinBounds(cy - 1) || !MinecraftBlockExaminer.canStandOn(source.getMaterialAt(cx, cy - 1, cz))) continue;
                    Vector jumpPoint = new Vector((double)cx + 0.5 + (double)DX[i] * INV_LEN[i] * 0.3, (double)cy, (double)cz + 0.5 + (double)DZ[i] * INV_LEN[i] * 0.3);
                    point.addCallback(new JumpCallback(jumpPoint));
                    Vector vector = new Vector(cx, cy, cz);
                    PathPoint next = point.createAtOffset(vector, 1.5f);
                    next.setPathVectors((List<Vector>)ImmutableList.of((Object)jumpPoint, (Object)vector));
                    neighbours.add(next);
                    continue block1;
                }
                px = bx;
                py = by;
                pz = bz;
            }
        }
    }

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        return BlockExaminer.StandableState.IGNORE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    private boolean isClearColumn(BlockSource source, int x, int y, int z) {
        int height = this.entityHeight.get();
        for (int h = 0; h < height; ++h) {
            if (MinecraftBlockExaminer.canStandIn(source.getMaterialAt(x, y + h, z))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        return BlockExaminer.PassableState.IGNORE;
    }

    private static int floor(double v) {
        int i = (int)v;
        return v < (double)i ? i - 1 : i;
    }

    private static class JumpCallback
    implements PathPoint.PathCallback {
        private final Vector jumpPoint;
        private boolean reached;

        public JumpCallback(Vector jumpPoint) {
            this.jumpPoint = jumpPoint;
        }

        @Override
        public void onReached(NPC npc, Block point) {
            this.reached = true;
        }

        @Override
        public void run(NPC npc, Block point, List<Block> path, int index) {
            if (!this.reached || npc.getEntity().getLocation().toVector().distance(this.jumpPoint) > 0.2) {
                return;
            }
            this.reached = false;
            npc.getEntity().setVelocity(npc.getEntity().getVelocity().setY(0.42));
        }
    }
}

