/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;

public class Sequence
extends Composite {
    private Behavior executing;
    private int executingIndex = -1;

    private Sequence(Behavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    private Sequence(Collection<Behavior> behaviors) {
        super(behaviors);
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
        this.executingIndex = -1;
    }

    private void resetCurrent() {
        this.stopExecution(this.executing);
        this.executing = null;
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus next;
        this.tickParallel();
        List<Behavior> behaviors = this.getBehaviors();
        if (this.executing == null && (next = this.selectNext(behaviors)) != BehaviorStatus.RUNNING) {
            this.resetCurrent();
            return next;
        }
        BehaviorStatus status = this.executing.run();
        switch (status) {
            case FAILURE: {
                this.resetCurrent();
                return BehaviorStatus.FAILURE;
            }
            case RESET_AND_REMOVE: {
                behaviors.remove(this.executingIndex--);
                return this.selectNext(behaviors);
            }
            case SUCCESS: {
                this.resetCurrent();
                return this.selectNext(behaviors);
            }
        }
        return status;
    }

    private BehaviorStatus selectNext(List<Behavior> behaviors) {
        if (++this.executingIndex >= behaviors.size()) {
            return BehaviorStatus.SUCCESS;
        }
        this.executing = behaviors.get(this.executingIndex);
        if (!this.executing.shouldExecute()) {
            this.resetCurrent();
            return BehaviorStatus.FAILURE;
        }
        return BehaviorStatus.RUNNING;
    }

    public String toString() {
        return "Sequence [executing=" + this.executing + ", executingIndex=" + this.executingIndex + ", getBehaviors()=" + this.getBehaviors() + "]";
    }

    public static Sequence createSequence(Behavior ... behaviors) {
        return Sequence.createSequence(Arrays.asList(behaviors));
    }

    public static Sequence createSequence(Collection<Behavior> behaviors) {
        return new Sequence(behaviors);
    }
}

