/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.Pose;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

@TraitName(value="poses")
public class Poses
extends Trait {
    @Persist
    private String defaultPose;
    private final Map<String, Pose> poses = new HashMap<String, Pose>();

    public Poses() {
        super("poses");
    }

    public boolean addPose(String name, Location location) {
        return this.addPose(name, location, false);
    }

    public boolean addPose(String name, Location location, boolean isDefault) {
        name = name.toLowerCase();
        Pose newPose = new Pose(name, location.getPitch(), location.getYaw());
        if (this.poses.containsKey(name)) {
            return false;
        }
        this.poses.put(name, newPose);
        if (isDefault) {
            this.defaultPose = name;
        }
        return true;
    }

    private void assumePose(float yaw, float pitch) {
        if (!this.npc.isSpawned()) {
            this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.COMMAND);
        }
        this.npc.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToHave(yaw, pitch);
    }

    public void assumePose(Location location) {
        this.assumePose(location.getYaw(), location.getPitch());
    }

    public void assumePose(String flag) {
        if (flag == null) {
            return;
        }
        Pose pose = this.poses.get(flag.toLowerCase());
        this.assumePose(pose.getYaw(), pose.getPitch());
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Pose").console(sender instanceof ConsoleCommandSender);
        paginator.addLine("<green>ID  <yellow>Name  <red>Pitch/Yaw");
        int i = 0;
        for (Pose pose : this.poses.values()) {
            String line = "<green>" + i + "<yellow>  " + pose.getName() + "<red>  " + pose.getPitch() + " " + pose.getYaw();
            paginator.addLine(line);
            ++i;
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", page);
        }
    }

    public Pose getPose(String name) {
        return name == null ? null : this.poses.get(name.toLowerCase());
    }

    public boolean hasPose(String pose) {
        if (pose == null) {
            return false;
        }
        return this.poses.containsKey(pose.toLowerCase());
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.poses.clear();
        for (DataKey sub : key.getRelative("list").getIntegerSubKeys()) {
            try {
                String[] parts = sub.getString("").split(";");
                this.poses.put(parts[0].toLowerCase(), new Pose(parts[0], Float.parseFloat(parts[1]), Float.parseFloat(parts[2])));
            }
            catch (NumberFormatException e) {
                Messaging.logTr("citizens.notifications.skipping-invalid-pose", sub.name(), e.getMessage());
            }
        }
    }

    public boolean removePose(String pose) {
        return pose == null ? false : this.poses.remove(pose.toLowerCase()) != null;
    }

    @Override
    public void run() {
        LookClose trait;
        if (!this.hasPose(this.defaultPose) || this.npc.getNavigator().isNavigating()) {
            return;
        }
        if (this.npc.hasTrait(LookClose.class) && (trait = this.npc.getOrAddTrait(LookClose.class)).isEnabled() && trait.canSeeTarget()) {
            return;
        }
        this.assumePose(this.defaultPose);
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("list");
        int i = 0;
        for (Pose pose : this.poses.values()) {
            key.setString("list." + i, pose.stringValue());
            ++i;
        }
    }

    public void setDefaultPose(String pose) {
        this.defaultPose = pose;
    }
}

