/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;

public class BlockBuiltScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag oldMaterial;
    public MaterialTag newMaterial;
    public BlockCanBuildEvent event;

    public BlockBuiltScriptEvent() {
        this.registerCouldMatcher("<block> being built (on <block>)");
        this.registerTextDetermination("buildable", evt -> evt.event.setBuildable(true));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(4, this.oldMaterial)) {
            return false;
        }
        if (!path.tryArgObject(0, this.newMaterial)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public void cancellationChanged() {
        this.event.setBuildable(!this.cancelled);
        super.cancellationChanged();
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "new_material" -> this.newMaterial;
            case "old_material" -> this.oldMaterial;
            case "buildable" -> new ElementTag(this.event.isBuildable());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBlockBuilt(BlockCanBuildEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.oldMaterial = new MaterialTag(event.getBlock());
        this.newMaterial = new MaterialTag(event.getBlockData());
        this.cancelled = !event.isBuildable();
        this.event = event;
        this.fire((Event)event);
    }
}

