/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class DetermineCommand
extends AbstractCommand {
    public DetermineCommand() {
        this.setName("determine");
        this.setSyntax("determine (passively) [<value>]");
        this.setRequiredArguments(1, 2);
        this.isProcedural = true;
        this.setBooleanHandled("passively");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("outcome")) {
                scriptEntry.addObject("outcome", arg);
                continue;
            }
            arg.reportUnhandled();
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Argument outcomeArg = (Argument)scriptEntry.getObject("outcome");
        if (outcomeArg == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a value to determine.");
        }
        boolean passively = scriptEntry.argAsBoolean("passively");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), DetermineCommand.db("outcome", outcomeArg), DetermineCommand.db("passively", passively), new QueueTag(scriptEntry.getResidingQueue()));
        }
        ScriptQueue queue = scriptEntry.getResidingQueue();
        ListTag determines = queue.determinations;
        if (determines == null) {
            queue.determinations = determines = new ListTag();
        }
        determines.addObject(outcomeArg.hasPrefix() ? outcomeArg.getRawElement() : outcomeArg.object);
        if (queue.determinationTarget != null) {
            queue.determinationTarget.applyDetermination(outcomeArg.prefix, outcomeArg.object);
        }
        if (!passively) {
            scriptEntry.getResidingQueue().clear();
            scriptEntry.getResidingQueue().stop();
        }
    }
}

